% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff.R
\name{cff}
\alias{cff}
\title{Fast formatting of numbers}
\usage{
cff(num, low_ci, up_ci, dig = 0, method = c("num_only", "num_ci", "ci"))
}
\arguments{
\item{num}{A numeric. The number to format.}

\item{low_ci}{A numeric. Lower end of a confidence interval}

\item{up_ci}{A numeric. Upper end of a confidence interval}

\item{dig}{A numeric. Number of digits}

\item{method}{What sort of printing do you need? (see Details)}
}
\value{
A character vector with the formatted number(s)
}
\description{
This is a formatting function for consistent number reporting.
}
\details{
Set \code{method} according to the printing you like: a unique number
with \code{num_only} (default), the number and its confidence interval
with \code{num_ci}, a \code{ci} only (for example a range of time to onset)
The function properly returns \code{NA} when input is missing.
}
\examples{
num <- c(0.1, 0.02, 1.658)

cff(num)

cff(num, dig = 2)

cff(num = num[[1]],
     low_ci = num[[2]],
     up_ci = num[[3]],
     method = "num_ci",
     dig = 2)
}
\keyword{number}
