% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_upload.R
\name{prepare_map_custom_files}
\alias{prepare_map_custom_files}
\title{Converts map information in custom format files to viewmap object}
\usage{
prepare_map_custom_files(dosages, phases, genetic_map, mks_pos = NULL)
}
\arguments{
\item{dosages}{TSV or TSV.GZ file with both parents dosage information.
It should contain four columns: 1) character vector with chromosomes ID; 
2) Character vector with markers ID; 3) Character vector with parent ID; 
4) numerical vector with dosage.}

\item{phases}{TSV or TSV.GZ file with phases information. It should contain:
1) Character vector with chromosome ID; 2) Character vector with marker ID;
3 to (ploidy number)*2 columns with each parents haplotypes.}

\item{genetic_map}{TSV or TSV.GZ file with the genetic map information}

\item{mks_pos}{TSV or TSV.GZ file with table with three columns: 1) marker ID; 
2) genome position; 3) chromosome}
}
\value{
object of class \code{viewmap}
}
\description{
Converts map information in custom format files to viewmap object
}
\keyword{internal}
