% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treePlot.R
\name{plotCoefs}
\alias{plotCoefs}
\title{plotting function to investigate estimated coefficients}
\usage{
plotCoefs(object, s = NULL, ...)
}
\arguments{
\item{object}{fitted vennLasso object}

\item{s}{lambda value for the predictions. Only one can be specified at a time}

\item{...}{other graphical parameters for the plot}
}
\description{
plotting function to investigate estimated coefficients
}
\examples{
set.seed(123)

dat.sim <- genHierSparseData(ncats = 3, nvars = 25, nobs = 200)

fit <- vennLasso(x = dat.sim$x, y = dat.sim$y, groups = dat.sim$group.ind)

plotCoefs(fit, s = fit$lambda[22])


}
