% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wide_to_long.R
\name{wide_to_long}
\alias{wide_to_long}
\title{Transform data.frame from wide to long format}
\usage{
wide_to_long(df, column_with_data = names(df), column_fixed, geometry)
}
\arguments{
\item{df}{data.frame with three column.}

\item{column_with_data}{Character column with data}

\item{column_fixed}{Character,  column that will remain fixed}

\item{geometry}{To return a sf}
}
\value{
long data.frame.
}
\description{
\code{\link{wide_to_long}} transform data.frame from wide to
long format
}
\examples{
\dontrun{
data(net)
net <- sf::st_set_geometry(net, NULL)
df <- wide_to_long(df = net)
head(df)
}
}
\seealso{
\code{\link{emis_hot_td}} \code{\link{emis_cold_td}}  \code{\link{long_to_wide}}
}
