% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform}
\alias{transform}
\title{Convert cover scales to percent cover}
\usage{
transform(x, ...)
}
\arguments{
\item{...}{Further arguments passed from or to other methods.}

\item{_data, x}{Either a factor or character vector, or a \linkS4class{vegtable} object.}

\item{conversion}{An object of class \linkS4class{vegtable}.}

\item{from}{Scale name of values in \code{x} as character value.}

\item{to}{Name of the column in slot \code{samples} for writing converted values.}

\item{replace}{Logical value indicating whether existing cover values should
be replaced or not.}

\item{rule}{Rule applied for the conversion (see details).}

\item{zeroto}{Value used to replace levels with bottom at 0\% cover.}
}
\value{
Either a vector or a \linkS4class{vegtable} object.
}
\description{
Convert values of a categorical cover scale to percentage values.

This function requires as input a \linkS4class{coverconvert} object which contains
the conversion tables.

In the case of \linkS4class{vegtable} objects, the conversion is already embedded
in the slot \code{coverconvert}.

Three rules are implemented for transformation, either \code{top} (values
transformed to the top of the range), \code{middle} (transformation at the
midpoint), and \code{bottom} (conversion at the lowest value of the
range). In the later case, transformation ranges starting at 0\% of cover
can be set to a different value by the argument \code{zeroto}.

When \code{replace=FALSE}, existing values of cover in the \linkS4class{vegtable}
object will be maintained. Since there is not a standard naming of cover
values, in the transformation the name of cover variable should be
indicated in the argument \code{to}.
}
\seealso{
\link{vegtable-deprecated}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
\keyword{internal}
