# R
# library(vegdata)
# 
# db <- 'taxatest'
# obs <- tv.coverperc(db)
# site <- tv.site(db)

tv.write <- function(x, site, name, cover=c('code','perc'), overwrite = FALSE, ...) {
warning('This function is highly experimental and will most probably not work as expected.')
  cover <- match.arg(cover)
  if('veg' %in% class(x)) {
    x <- reShape.veg(x, ...)
    cover <- 'perc'
#   names(x)[names(x)=='COVER_PERC'] <- 'COVER_CODE'
# print(names(x))
    if(cover == 'perc') {
      x$COVER_CODE <- as.character(x$COVER_PERC)
      site$COVERSCALE <- '00'
      x <- x[,c('RELEVE_NR','SPECIES_NR', 'COVER_CODE', 'LAYER')]
    }
  }

if(!any(c('tv.obs','vw.obs') %in% class(x))) stop('Species observations must be of either \"tv.obs\" or \"vw.obs\" class.')
  if(!all(c('RELEVE_NR') %in% names(x))) 
    stop('column names of species observations must contain RELEVE_NR')

  if(!overwrite) if(file.exists(file.path(options('tv_home'), 'Data', name))) stop('Database ', name, ' already exists.')
  site$DATE <- gsub('-','',site$DATE)
#  site$RELEVE_NR <- as.integer(as.character(site$RELEVE_NR))
  dir.create(file.path(options('tv_home'), 'Data', name), showWarnings = TRUE)
  write.dbf(site, file.path(options('tv_home'), 'Data', name, 'tvhabita.dbf'))
  write.dbf(x, file.path(options('tv_home'), 'Data', name, 'tvabund.dbf'))
  file.copy(from=file.path(options('tv_home'), 'Data/taxatest/remarks.dbf'), to=file.path(options('tv_home'),'Data', name, 'remarks.dbf'), overwrite = overwrite)
  cat('Turboveg database', name, 'written to', unlist(options('tv_home')), '\n Please specify correct species list when first opening the database in Turboveg.\n', 'If Turboveg is not able to open the database, try to exclude the biggest text fields.\n')
}

# tv.write(obs, site, 'test2', overwrite=TRUE)
