"print.permutest.cca" <-
    function (x, ...) 
{
    cat("\nPermutation test for", x$method, "\n\n")
    writeLines(strwrap(pasteCall(x$call)))
    Pval <- (sum(x$F.perm >= x$F.0) + 1)/(x$nperm + 1)
    cat("Permutation test for ")
    if (x$first)
        cat("first constrained eigenvalue\n")
    else
        cat("all constrained eigenvalues\n")
    cat("Pseudo-F:\t", x$F.0, "\n")
    cat("Significance:\t", format.pval(Pval), 
        "\n")
    cat("Based on", x$nperm, "permutations under", x$model, "model")
    if (!is.null(x$strata)) 
        cat(",\nstratified within factor", x$strata)
    cat(".\n\n")
    invisible(x)
}
