% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LHS.R
\name{LHS}
\alias{LHS}
\alias{MLHS}
\alias{SLHS}
\alias{RSLHS}
\title{Latin Hypercube Sampling}
\usage{
LHS(n, m = 3, lim = c(-1, 1))

MLHS(n, m = 3, lim = c(-1, 1))

SLHS(n, m = 3, lim = c(-1, 1))

RSLHS(n, m = 3, lim = c(-1, 1))
}
\arguments{
\item{n}{number of design points to generate}

\item{m}{number of design factors}

\item{lim}{limits of the coordinates in all dimensions}
}
\value{
Matrix with samples as rows.
}
\description{
Different versions of latin hypercube sampling (LHS): ordinary LHS,  midpoint LHS, symmetric LHS or randomized symmetric LHS. LHS is a method 
for constructing space-filling designs. They can be more efficient for hypercuboidal design regions than other sampling methods.
}
\examples{

set.seed(1234)
pts <- seq(-1, 1, length = 11)

# Ordinary LHS
samp <- LHS(n = 10, m = 2)
plot(samp, main = "LHS")
abline(h = pts, v = pts, col = "lightgrey")

# Midpoint LHS
samp <- MLHS(n = 10, m = 2)
plot(samp, main = "MLHS")
abline(h = pts, v = pts, col = "lightgrey")

# Symmetric LHS
samp <- SLHS(n = 10, m = 2)
plot(samp, main = "SLHS")
abline(h = pts, v = pts, col = "lightgrey")

# Randomized Symmetric LHS
samp <- RSLHS(n = 10, m = 2)
plot(samp, main = "RSLHS")
abline(h = pts, v = pts, col = "lightgrey")
}
\references{
Pieter C. Schoonees, Niel J. le Roux, Roelof L.J. Coetzer (2016). Flexible Graphical Assessment of 
Experimental Designs in R: The vdg Package. \emph{Journal of Statistical Software}, 74(3), 1-22. 
 \doi{10.18637/jss.v074.i03}.
}
\author{
Pieter C. Schoonees
}
\keyword{design}
