% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast.R, R/type2.R
\name{vec_default_cast}
\alias{vec_default_cast}
\alias{vec_default_ptype2}
\title{Default cast and ptype2 methods}
\usage{
vec_default_cast(x, to, ..., x_arg = "", to_arg = "", call = caller_env())

vec_default_ptype2(x, y, ..., x_arg = "", y_arg = "", call = caller_env())
}
\arguments{
\item{x}{Vectors to cast.}

\item{to}{Type to cast to. If \code{NULL}, \code{x} will be returned as is.}

\item{...}{For \code{vec_cast_common()}, vectors to cast. For
\code{vec_cast()}, \code{vec_cast_default()}, and \code{vec_restore()}, these
dots are only for future extensions and should be empty.}

\item{x_arg}{Argument name for \code{x}, used in error messages to
inform the user about the locations of incompatible types
(see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}

\item{to_arg}{Argument name \code{to} used in error messages to
inform the user about the locations of incompatible types
(see \code{\link[=stop_incompatible_type]{stop_incompatible_type()}}).}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\description{
These functions are automatically called when no \code{\link[=vec_ptype2]{vec_ptype2()}} or
\code{\link[=vec_cast]{vec_cast()}} method is implemented for a pair of types.
\itemize{
\item They apply special handling if one of the inputs is of type
\code{AsIs} or \code{sfc}.
\item They attempt a number of fallbacks in cases where it would be too
inconvenient to be strict:
\itemize{
\item If the class and attributes are the same they are considered
compatible. \code{vec_default_cast()} returns \code{x} in this case.
\item In case of incompatible data frame classes, they fall back to
\code{data.frame}. If an incompatible subclass of tibble is
involved, they fall back to \code{tbl_df}.
}
\item Otherwise, an error is thrown with \code{\link[=stop_incompatible_type]{stop_incompatible_type()}} or
\code{\link[=stop_incompatible_cast]{stop_incompatible_cast()}}.
}
}
\keyword{internal}
