% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice-interleave.R
\name{vec_interleave}
\alias{vec_interleave}
\title{Interleave many vectors into one vector}
\usage{
vec_interleave(
  ...,
  .ptype = NULL,
  .name_spec = NULL,
  .name_repair = c("minimal", "unique", "check_unique", "universal")
)
}
\arguments{
\item{...}{Vectors to interleave. These will be recycled to a common size.}

\item{.ptype}{If \code{NULL}, the default, the output type is determined by
computing the common type across all elements of \code{...}.

Alternatively, you can supply \code{.ptype} to give the output known type.
If \code{getOption("vctrs.no_guessing")} is \code{TRUE} you must supply this value:
this is a convenient way to make production code demand fixed types.}

\item{.name_spec}{A name specification for combining
inner and outer names. This is relevant for inputs passed with a
name, when these inputs are themselves named, like \code{outer = c(inner = 1)}, or when they have length greater than 1: \code{outer = 1:2}. By default, these cases trigger an error. You can resolve
the error by providing a specification that describes how to
combine the names or the indices of the inner vector with the
name of the input. This specification can be:
\itemize{
\item A function of two arguments. The outer name is passed as a
string to the first argument, and the inner names or positions
are passed as second argument.
\item An anonymous function as a purrr-style formula.
\item A glue specification of the form \code{"{outer}_{inner}"}.
\item An \code{\link[rlang:zap]{rlang::zap()}} object, in which case both outer and inner
names are ignored and the result is unnamed.
}

See the \link[=name_spec]{name specification topic}.}

\item{.name_repair}{How to repair names, see \code{repair} options in
\code{\link[=vec_as_names]{vec_as_names()}}.}
}
\description{
\code{vec_interleave()} combines multiple vectors together, much like \code{\link[=vec_c]{vec_c()}},
but does so in such a way that the elements of each vector are interleaved
together.

It is a more efficient equivalent to the following usage of \code{vec_c()}:\preformatted{vec_interleave(x, y) == vec_c(x[1], y[1], x[2], y[2], ..., x[n], y[n])
}
}
\section{Dependencies}{

\subsection{vctrs dependencies}{
\itemize{
\item \code{\link[=vec_unchop]{vec_unchop()}}
}
}
}

\examples{
# The most common case is to interleave two vectors
vec_interleave(1:3, 4:6)

# But you aren't restricted to just two
vec_interleave(1:3, 4:6, 7:9, 10:12)

# You can also interleave data frames
x <- data_frame(x = 1:2, y = c("a", "b"))
y <- data_frame(x = 3:4, y = c("c", "d"))

vec_interleave(x, y)
}
