% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arith.R
\name{vec_arith}
\alias{vec_arith}
\alias{vec_arith.default}
\alias{vec_arith.logical}
\alias{vec_arith.numeric}
\alias{vec_arith_base}
\alias{MISSING}
\title{Arithmetic operations}
\usage{
vec_arith(op, x, y, ...)

\method{vec_arith}{default}(op, x, y, ...)

\method{vec_arith}{logical}(op, x, y, ...)

\method{vec_arith}{numeric}(op, x, y, ...)

vec_arith_base(op, x, y)

MISSING()
}
\arguments{
\item{op}{An arithmetic operator as a string}

\item{x, y}{A pair of vectors. For \code{!}, unary \code{+} and unary \code{-}, \code{y} will be
a sentinel object of class \code{MISSING}, as created by \code{MISSING()}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\description{
This generic provides a common double dispatch mechanism for all infix
operators (\code{+}, \code{-}, \code{/}, \code{*}, \code{^}, \code{\%\%}, \code{\%/\%}, \code{!}, \code{&}, \code{|}). It is used
to power the default arithmetic and boolean operators for \link{vctr}s objects,
overcoming the limitations of the base \link{Ops} generic.
}
\details{
\code{vec_arith_base()} is provided as a convenience for writing methods. It
recycles \code{x} and \code{y} to common length then calls the base operator with the
underlying \code{\link[=vec_data]{vec_data()}}.

\code{vec_arith()} is also used in \code{diff.vctrs_vctr()} method via \code{-}.
}
\examples{
d <- as.Date("2018-01-01")
dt <- as.POSIXct("2018-01-02 12:00")
t <- as.difftime(12, unit = "hours")

vec_arith("-", dt, 1)
vec_arith("-", dt, t)
vec_arith("-", dt, d)

vec_arith("+", dt, 86400)
vec_arith("+", dt, t)
vec_arith("+", t, t)

vec_arith("/", t, t)
vec_arith("/", t, 2)

vec_arith("*", t, 2)
}
\seealso{
\code{\link[=stop_incompatible_op]{stop_incompatible_op()}} for signalling that an arithmetic
operation is not permitted/supported.

See \code{\link[=vec_math]{vec_math()}} for the equivalent for the unary mathematical
functions.
}
\keyword{internal}
