% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.ave.cor.nonover}
\alias{se.ave.cor.nonover}
\title{Computes the standard error for the average of two Pearson correlations with
no variables in common that have been estimated from the same sample}
\usage{
se.ave.cor.nonover(cor12, cor34, cor13, cor14, cor23, cor24, n)
}
\arguments{
\item{cor12}{estimated correlation between variables 1 and 2}

\item{cor34}{estimated correlation between variables 3 and 4}

\item{cor13}{estimated correlation between variables 1 and 3}

\item{cor14}{estimated correlation between variables 1 and 4}

\item{cor23}{estimated correlation between variables 2 and 3}

\item{cor24}{estimated correlation between variables 2 and 4}

\item{n}{sample size}
}
\value{
Returns a two-row matrix. The first row gives results for the average
correlation and the second row gives the results with a Fisher
transformation. The columns are:
\itemize{
\item Estimate - estimated average of cor12 and cor34
\item SE - standard error
\item VAR(cor12) - variance of cor12
\item VAR(cor34) - variance of cor34
\item COV(cor12,cor34) - covariance of cor12 and cor34
}
}
\description{
In a study that reports the sample size and six correlations (cor12, cor34,
cor13, cor14, cor23, and cor24) where variables 1 and 3 are different
measurements of one attribute and variables 2 and 4 are different
measurements of a second attribute, this function can be used to compute the
average of cor12 and cor34 and its standard error. Note that cor12 and cor34
have no variable in common (i.e., no "overlapping" variable). The average
correlation and the standard error from this function can be used as
input in the \link[vcmeta]{meta.ave.cor.gen} function in a meta-analysis where
some studies have reported cor12 and other studies have reported cor34.
}
\examples{
se.ave.cor.nonover(.357, .398, .755, .331, .347, .821, 100)

# Should return:
#               Estimate         SE VAR(cor12)  VAR(cor34) COV(cor12,cor34)
# Correlation:  0.377500 0.07768887 0.00784892 0.007301895      0.004495714
# Fisher:       0.397141 0.09059993 0.01030928 0.010309278      0.006122153


}
