% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.var}
\alias{meta.ave.var}
\title{Confidence interval for an average variance}
\usage{
meta.ave.var(alpha, var, n, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{var}{vector of sample variances}

\item{n}{vector of sample sizes}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - estimated variance
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate and confidence interval for an average variance
from two or more studies. The estimated average variance or the
upper limit could be used as a variance planning value in sample
size planning.
}
\examples{
var <- c(26.63, 22.45, 34.12)
n <- c(40, 30, 50)
meta.ave.var(.05, var, n, bystudy = TRUE)

# Should return:
#         Estimate       LL       UL
# Average 27.73333 21.45679 35.84589
# Study 1 26.63000 17.86939 43.90614
# Study 2 22.45000 14.23923 40.57127
# Study 3 34.12000 23.80835 52.98319


}
