% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.meanratio.ps}
\alias{meta.lm.meanratio.ps}
\title{Meta-regression analysis for paired-samples log mean ratios}
\usage{
meta.lm.meanratio.ps(alpha, m1, m2, sd1, sd2, cor, n, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of estimated means for group 1}

\item{m2}{vector of estimated means for group 2}

\item{sd1}{vector of estimated SDs for group 1}

\item{sd2}{vector of estimated SDs for group 2}

\item{cor}{vector of estimated correlations}

\item{n}{vector of sample sizes}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item exp(Estimate) - the exponentiated estimate
\item exp(LL) - lower limit of the exponentiated confidence interval
\item exp(UL) - upper limit of the exponentiated confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a paired-samples
log mean ratio. The estimates are OLS estimates with robust standard
errors that accommodate residual heteroscedasticity. The exponentiated
slope estimate for a predictor variable describes a multiplicative
change in the mean ratio associated with a 1-unit increase in that
predictor variable.
}
\examples{
n <- c(65, 30, 29, 45, 50)
cor <- c(.87, .92, .85, .90, .88)
m1 <- c(20.1, 20.5, 19.3, 21.5, 19.4)
m2 <- c(10.4, 10.2, 8.5, 10.3, 7.8)
sd1 <- c(9.3, 9.9, 10.1, 10.5, 9.8)
sd2 <- c(7.8, 8.0, 8.4, 8.1, 8.7)
x1 <- c(2, 3, 3, 4, 4)
X <- matrix(x1, 5, 1)
meta.lm.meanratio.ps(.05, m1, m2, sd1, sd2, cor, n, X)

# Should return: 
#      Estimate         SE           LL        UL        z     p
# b0 0.50957008 0.13000068  0.254773424 0.7643667 3.919749 0.000
# b1 0.07976238 0.04133414 -0.001251047 0.1607758 1.929697 0.054
#     exp(Estimate)   exp(LL)  exp(UL)
# b0       1.664575 1.2901693 2.147634
# b1       1.083030 0.9987497 1.174422


}
