% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.prop.ps}
\alias{meta.ave.prop.ps}
\title{Confidence interval for an average proportion difference in
paired-samples studies}
\usage{
meta.ave.prop.ps(alpha, f11, f12, f21, f22, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f11}{vector of frequency counts in cell 1,1}

\item{f12}{vector of frequency counts in cell 1,2}

\item{f21}{vector of frequency counts in cell 2,1}

\item{f22}{vector of frequency counts in cell 2,2}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - the estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average proportion difference from two or more studies.
}
\examples{
f11 <- c(17, 28, 19)
f12 <- c(43, 56, 49)
f21 <- c(3, 5, 5)
f22 <- c(37, 54, 39)
meta.ave.prop.ps(.05, f11, f12, f21, f22, bystudy = TRUE)

# Should return:
#          Estimate         SE        LL        UL
# Average 0.3809573 0.03000016 0.3221581 0.4397565
# Study 1 0.3921569 0.05573055 0.2829270 0.5013867
# Study 2 0.3517241 0.04629537 0.2609869 0.4424614
# Study 3 0.3859649 0.05479300 0.2785726 0.4933572


}
\references{
\insertRef{Bonett2014}{vcmeta}
}
