% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.prop1}
\alias{meta.lm.prop1}
\title{Meta-regression analysis for single proportions}
\usage{
meta.lm.prop1(alpha, f, n, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{vector of sample frequency counts}

\item{n}{vector of sample sizes}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a proportion
from a single group. The estimates are OLS estimates with
standard errors that accomodate residual heteroscedasticity.
}
\examples{
f <- c(38, 26, 24, 15, 45, 38)
n <- c(80, 60, 70, 50, 180, 200)
x1 <- c(10, 15, 18, 22, 24, 30)
X <- matrix(x1, 6, 1)
meta.lm.prop1(.05, f, n, X)

# Should return: 
#       Estimate         SE         z p          LL           UL
# b0  0.63262816 0.06845707  9.241239 0  0.49845477  0.766801546
# b1 -0.01510565 0.00290210 -5.205076 0 -0.02079367 -0.009417641


}
