% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.spear}
\alias{meta.ave.spear}
\title{Confidence interval for an average Spearman correlation}
\usage{
meta.ave.spear(alpha, n, cor, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{cor}{vector of sample Spearman correlations}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate
across all studies.  If bystudy is true, there is 1 additional row for
each study.  The matrix has the following columns:
\itemize{
\item Estimate - the estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average Spearman correlation. The Spearman correlation is preferred to
the Pearson correlation if the relation between the two quantitative
variables is monotonic rather than linear or if the bivariate normality
assumption is not plausible.
}
\examples{
n <- c(150, 200, 300, 200, 350)
cor <- c(.14, .29, .16, .21, .23)
meta.ave.spear(.05, n, cor, bystudy = TRUE)

# Should return:
#         Estimate         SE          LL        UL
# Average    0.206 0.02944265  0.14763960 0.2629309
# Study 1    0.140 0.08031750 -0.02151639 0.2943944
# Study 2    0.290 0.06492643  0.15476515 0.4145671
# Study 3    0.160 0.05635101  0.04689807 0.2690514
# Study 4    0.210 0.06776195  0.07187439 0.3402225
# Study 5    0.230 0.05069710  0.12690280 0.3281809


}
\references{
\insertRef{Bonett2008a}{vcmeta}
}
