% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ve.R
\name{EfficacyCI}
\alias{EfficacyCI}
\title{Efficacy summary (mean, median, confidence intervals)}
\usage{
EfficacyCI(efficacySet, ci = 0.95)
}
\arguments{
\item{efficacySet}{numeric vector - vector of estimated efficacy values}

\item{ci}{numeric - required confidence level}
}
\value{
named list - mean, median, CILow, CIHigh
}
\description{
Function summarizes efficacy statistics (mean, median, confidence intervals) based on the set of estimated efficacy values and chosen condfidence interval.
}
\details{
Confidence intervals are calculated using quantiles of estimated efficacy values.
}
\examples{
# Load required packages
library(dplyr)

# Load an example dataset
data(data_temp)
Data.vaccinated <- filter(data_temp, vaccine == 1)
Data.control <- filter(data_temp, vaccine == 0)

# Fit logistic model relating neutralizing titer to disease status, specific to serotype 2
logisticFit <- glm(disease_any ~ nAb1, data = data_temp, family = binomial())

# Estimate 95\\% confidence interval of vaccine efficacy based on the fitted model
efficacySet <- glmParametricSampling(logisticFit, nboot = 500, Data.vaccinated, Data.control)
EfficacyCI(efficacySet)

}
