% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIC-SVC_mle.R
\name{IC.SVC_mle}
\alias{IC.SVC_mle}
\alias{BIC.SVC_mle}
\alias{AIC.SVC_mle}
\title{Conditional Akaike's and Bayesian Information Criteria}
\usage{
\method{BIC}{SVC_mle}(object, ...)

\method{AIC}{SVC_mle}(object, conditional = "BW", ...)
}
\arguments{
\item{object}{\code{\link{SVC_mle}} object}

\item{...}{further arguments}

\item{conditional}{string. If \code{conditional = "BW"}, the
conditional AIC is calculated.}
}
\value{
numeric, value of information criteria
}
\description{
Methods to calculate information criteria for
\code{\link{SVC_mle}} objects. Currently, two are supported: the conditional
Akaike's Information Criteria \eqn{cAIC = -2*log-likelihood + 2*(edof + df)}
and the Bayesian Information Criteria \eqn{BIC = -2*log-likelihood + log(n) * npar}.
Note that the Akaike's Information Criteria is of the corrected form, that
is: \eqn{edof} is the effective degrees of freedom which is derived as the
trace of the hat matrices and df is the degree of freedoms with respect to
mean parameters.
}
\author{
Jakob Dambon
}
