% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pen_functions.R
\name{d.Lq}
\alias{d.Lq}
\title{Derivative of \eqn{L^q} Norm Penalty}
\usage{
d.Lq(x, lambda = 1, q = 1, d.side = "both")
}
\arguments{
\item{x}{numeric.}

\item{lambda}{non-negative scalar, shrinkage parameter.}

\item{q}{non-negative scalar, norm parameter..}

\item{d.side}{side of serivative at origin. Default value is \code{"both"}, returning NA for \code{x == 0}. If set to \code{"RHS"}, then returns RHS derivative, i.e., \eqn{\lambda}, and \eqn{-\lambda} with \code{"LHS"}.}
}
\value{
derivative of \code{Lq(x)}, i.e., \deqn{L^q(x) = q\lambda | x|^{q-1}}, for \code{x == 0} return value is \code{NA}.
}
\description{
derivative of \code{\link{Lq}}, which is not differentiable at \code{x == 0}.
}
\examples{

d.Lq(-5:5)
d.Lq(-2:2, d.side = "LHS")
curve(d.Lq, from = -5, to = 5)
}
\author{
Jakob Dambon
}
