\name{fitted.varest}

\alias{fitted.varest}

\encoding{latin1}

\title{Fit method for objects of class varest}

\description{
  Returns the fitted values of a VAR(p)-model for objects generated by
  \command{VAR()}. Thereby the fitted.values-method is applied to the list
  element \code{varresult}, which is itself a list of
  \code{lm}-objects. 
}

\usage{
\method{fitted}{varest}(object, ...)
}

\arguments{
  \item{object}{An object of class \sQuote{\code{varest}}; generated by
    \command{VAR()}} 
  \item{\dots}{Currently not used.}
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York.  
}

\seealso{
  \code{\link{VAR}}
}

\examples{
\dontrun{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
fitted(var.2c)
}
}

\keyword{regression}
