% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/helpers.R
\name{parallel_stan}
\alias{parallel_stan}
\title{Wrapper for the stan function to parallelize chains}
\usage{
parallel_stan(model_code, standata, totaliter, warmup, thin = 1, chains, cl,
  cores, seeds, modelfit, verbose = FALSE, pars = NA, sample_file = NA,
  diagnostic_file = NA, init = "random", ...)
}
\arguments{
\item{model_code}{A character string of Stan code}

\item{standata}{A data list suitable for Stan for the model given}

\item{totaliter}{The total number of iterations for inference.
Note that the total number of iterations is automatically
distributed across chains.}

\item{warmup}{How many warmup iterations should be used?  Note
that every chain will use the same number of warmups and these
will be \emph{added on top of the total iterations} for each chain.}

\item{thin}{The thin used, default to 1 indicating that all samples
be saved.}

\item{chains}{The number of independent chains to run.}

\item{cl}{(optional) The name of a cluster to use to run the chains.
If not specified, the function will make a new cluster.}

\item{cores}{(optional) If the \code{cl} argument is not used,
this specifies the number of cores to make on the new cluster.
If both \code{cl} and \code{cores} are missing, defaults to
the minimum of the number of chains specified or the number of
cores available on the machine.}

\item{seeds}{(optional) A vector of random seeds the same length as the number
of independent chains being run, to make results replicable.
If missing, random seeds will be generated and stored for reference
in the output.}

\item{modelfit}{(optional) A compiled Stan model, if available, saves
compiling \code{model_code}.}

\item{verbose}{A logical whether to print verbose output
(defaults to \code{FALSE})}

\item{pars}{Parameter names from Stan to store}

\item{sample_file}{The sample file for Stan}

\item{diagnostic_file}{The diagnostic file for Stan}

\item{init}{A character string (\dQuote{random}) or a named list of starting values.}

\item{\dots}{Additional arguments, not currently used.}
}
\value{
a named list with three elements, the \code{results},
  compiled Stan \code{model}, and the random \code{seeds}
}
\description{
This funcntion takes Stan model code, compiles the Stan model,
and then runs multiple chains in parallel.
}
\examples{
# Make me!
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{utilities}

