% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{scale_color_vangogh}
\alias{scale_color_vangogh}
\alias{scale_colour_vangogh}
\title{Setup colour palette for ggplot2}
\usage{
scale_color_vangogh(
  ...,
  palette = "StarryNight",
  discrete = TRUE,
  alpha = 1,
  reverse = FALSE
)

scale_colour_vangogh(
  ...,
  palette = "StarryNight",
  discrete = TRUE,
  alpha = 1,
  reverse = FALSE
)
}
\arguments{
\item{...}{additional arguments to pass to scale_color_gradientn}

\item{palette}{Choose from 'vangogh_palettes' list}

\item{discrete}{whether to use a discrete colour palette}

\item{alpha}{transparency}

\item{reverse}{logical, Reverse the order of the colours?}
}
\value{
A scale_color_vangogh function
}
\description{
Setup colour palette for ggplot2
}
\examples{
library(ggplot2)
ggplot(mtcars, aes(mpg, wt)) +
  geom_point(aes(colour = factor(cyl))) +
  scale_colour_vangogh(palette = "StarryNight")
ggplot(mtcars, aes(mpg, wt)) +
  geom_point(aes(colour = hp)) +
  scale_colour_vangogh(palette = "StarryNight", discrete = FALSE)
ggplot(data = mpg) +
  geom_point(mapping = aes(x = displ, y = hwy, color = class)) +
  scale_colour_vangogh(palette = "StarryRhone")
ggplot(diamonds) +
  geom_bar(aes(x = cut, fill = clarity)) +
  scale_fill_vangogh()
}
