% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{BoundWaterEnvSummaryPlot}
\alias{BoundWaterEnvSummaryPlot}
\title{Bound Water Environment Summary Plot}
\usage{
BoundWaterEnvSummaryPlot(data, passed.waters = TRUE,
  title = "Bound Water Environment per Conservation")
}
\arguments{
\item{data}{The \code{h2o.clusters.summary} data.frame from the \code{ClusterWaters}
function containing the \code{nBvalue.mu} information. This data.frame is found
within the \code{h2o.cluster.passed} and \code{h2o.cluster.all}}

\item{passed.waters}{Logical indicator to plot results for waters \strong{passing}
\code{\link[=Mobility]{Mobility()}} and \code{\link[=NormalizedBvalue]{NormalizedBvalue()}} \emph{\strong{OR}} using \strong{all} waters within
the \code{PDB} files.}

\item{title}{The title for the plot}
}
\description{
Mean bound water environment summary per percent conservation
}
\details{
Constructs a line plot with the bound water environment measures for
the nearby protein and water atoms. The protein atomic density (ADN),
hydrophilicity, mobility, normalized B-values, and potential hydrogen bonds
are summarized for protein heavy atoms with 3.6 Angstroms along with the
mobility, normalized B-values, and hydrogen bonds are summarized for the
waters within 3.6 Angstroms of the protein and water atoms of interest,
respectively. The raw values are scaled to values between 0 and 1 and
plotted for each of the percent conservation available. Thus if there are
ten structures being analyzed the percent conservation can range from 10 to
100\% in 10\% increments. The protein related values are shown as solid
lines and the water related values are shown as dotted lines.

\emph{Interpreting the plot}
\itemize{
\item \strong{dark green}: protein atom density
\item \strong{medium green}: protein atom hydrophilicity
\item \strong{green}: protein mobility
\item \strong{pale green}: protein nBvalue
\item \strong{light green}: protein hydrogen bonds
\item \strong{dark blue}: water mobility
\item \strong{medium blue}: water nBvalue
\item \strong{blue}: water hydrogen bonds
}

This plot is based on Figure 3 of Sanschagrin and Kuhn (1998). Please note
the B-value have been replaced with normalized B-values and hydrophilicity
has been removed. Hydrophilicity was removed because the range between
average hydrophilicity values for the percent conservations would likely be
narrow. Due to the way scaling works, the lowest value is scaled to zero
and the greatest value is scaled to one. Scaling the mean hydrophilicity
values works against our goal of showing an overall tread and instead
creates confusion about the values.
}
\examples{
  \dontrun{
  bwe.summary.plot <- BoundWaterEnvSummaryPlot(data=thrombin10.conservedWaters,
                                               passed.waters=TRUE,
                                               title="Bound Water Environment per Conservation")
 }

}
\references{
Paul C Sanschagrin and Leslie A Kuhn. Cluster analysis of
consensus water sites in thrombin and trypsin shows conservation between
serine proteases and contributions to ligand specificity. \emph{Protein
Science}, 1998, \strong{7} (\emph{10}), pp 2054-2064.
\href{http://doi.org/10.1002/pro.5560071002}{DOI: 10.1002/pro.5560071002}
\href{http://www.ncbi.nlm.nih.gov/pubmed/9792092}{PMID: 9792092}
\href{http://www.kuhnlab.bmb.msu.edu/software/watch/index.html}{WatCH webpage}
}
\seealso{
Other plots: \code{\link{BoundWaterEnvPlots}},
  \code{\link{BvalueBarplot.summ}},
  \code{\link{BvalueBarplot}},
  \code{\link{ClusterSummaryPlots}},
  \code{\link{MobNormBvalEvalPlots}},
  \code{\link{MobilityBarplot.summ}},
  \code{\link{MobilityBarplot}},
  \code{\link{OccupancyBarplot.summ}},
  \code{\link{OccupancyBarplot}},
  \code{\link{nBvalueBarplot}},
  \code{\link{normBvalueBarplot.summ}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{plots}
