% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbls.r
\name{tbl_genome}
\alias{tbl_genome}
\title{Tibble for reference sizes.}
\usage{
tbl_genome(x, ..., .validate = TRUE)
}
\arguments{
\item{x}{A \code{data_frame}}

\item{...}{params for \code{\link[tibble:tibble]{tibble::tibble()}}}

\item{.validate}{check valid column names}
}
\description{
Equivalent to information in UCSC "chromSizes" files. Required column names are:
\code{chrom} and \code{size}
}
\examples{
genome <- tibble::tribble(
  ~chrom, ~size,
  'chr1', 1e6,
  'chr2', 1e7
)

is.tbl_genome(genome)
genome <- tbl_genome(genome)
is.tbl_genome(genome)

}
