% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{barplot,cellComparison-method}
\alias{barplot,cellComparison-method}
\title{Barplot of cellComparison object}
\usage{
\S4method{barplot}{cellComparison}(
  height,
  las = 1,
  cex.axis = 0.8,
  cex.legend = cex.axis,
  wrap = TRUE,
  ...
)
}
\arguments{
\item{height}{object of class \code{cellComparison}}

\item{las}{[\code{numeric}] in \code{{0,1,2,3}} determining axis label rotation}

\item{cex.axis}{[\code{numeric}] Magnification with respect to the current
setting of \code{cex} for axis annotation.}

\item{cex.legend}{[\code{numeric}] Magnification with respect to the current
setting of \code{cex} for legend annotation and title.}

\item{wrap}{[\code{logical}] Toggle wrapping of x-axis labels when their width
exceeds the width of the column.}

\item{...}{Graphical parameters passed to \code{\link[graphics]{barplot.default}}.}
}
\description{
Versions of a data set can be compared cell by cell using \code{\link{cells}}.
The result is a \code{cellComparison} object. This method creates a stacked bar
plot of the results.  See also \code{\link{plot,cellComparison-method}} for a
line chart.
}
\note{
Before plotting, underscores (\code{_}) and dots (\code{.}) in x-axis 
labels are replaced with spaces.
}
\seealso{
Other comparing: 
\code{\link{as.data.frame,cellComparison-method}},
\code{\link{as.data.frame,validatorComparison-method}},
\code{\link{barplot,validatorComparison-method}},
\code{\link{cells}()},
\code{\link{compare}()},
\code{\link{match_cells}()},
\code{\link{plot,cellComparison-method}},
\code{\link{plot,validatorComparison-method}}
}
\concept{comparing}
