% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\docType{methods}
\name{as.data.frame,validatorComparison-method}
\alias{as.data.frame,validatorComparison-method}
\title{Translate a validatorComparison object to data frame}
\usage{
\S4method{as.data.frame}{validatorComparison}(x, row.names = NULL,
  optional = FALSE, ...)
}
\arguments{
\item{x}{Object to coerce}

\item{row.names}{ignored}

\item{optional}{ignored}

\item{...}{arguments passed to other methods}
}
\value{
A data frame with the following columns.
\itemize{
 \item{\code{status}: Row names of the \code{validatorComparison} object.}
 \item{\code{version}: Column names of the \code{validatorComparison} object.}
 \item{\code{count}: Contents of the \code{validatorComparison} object.}
}
}
\description{
The performance of versions of a data set with regard to rule-based quality
requirements can be compared using using \code{\link{compare}}. The result is a
\code{validatorComparison} object, which can usefully be translated into a data
frame.
}
\examples{
data(retailers)

rules <- validator(turnover >=0, staff>=0, other.rev>=0)

# start with raw data
step0 <- retailers

# impute turnovers
step1 <- step0
step1$turnover[is.na(step1$turnover)] <- mean(step1$turnover,na.rm=TRUE)

# flip sign of negative revenues
step2 <- step1
step2$other.rev <- abs(step2$other.rev)
  
# create an overview of differences, comparing to the previous step
compare(rules, raw = step0, imputed = step1, flipped = step2, how="sequential")

# create an overview of differences compared to raw data
out <- compare(rules, raw = step0, imputed = step1, flipped = step2)
out

# graphical overview
plot(out)
barplot(out)

# transform data to data.frame (easy for use with ggplot)
as.data.frame(out)


}
\seealso{
Other comparing: \code{\link{as.data.frame,cellComparison-method}},
  \code{\link{barplot,cellComparison-method}},
  \code{\link{barplot,validatorComparison-method}},
  \code{\link{cells}}, \code{\link{compare}},
  \code{\link{match_cells}},
  \code{\link{plot,cellComparison-method}},
  \code{\link{plot,validatorComparison-method}}
}
\concept{comparing}
