% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{classify_sports}
\alias{classify_sports}
\title{Automated Sports Taxonomy Mapping}
\usage{
classify_sports(
  data,
  group_col = "all_group_names",
  output_col = "sports_clean"
)
}
\arguments{
\item{data}{Data frame containing athlete metadata.}

\item{group_col}{Character. Name of the column containing group/team names.
Default is "all_group_names".}

\item{output_col}{Character. Name for the new standardized sports column.
Default is "sports_clean".}
}
\value{
Data frame with an additional column containing standardized sports categories.
}
\description{
Applies regex-based pattern matching to standardize inconsistent sport/team
naming conventions into a clean categorical variable. This is the core
"value-add" for multi-sport organizations where team names may vary
(e.g., "Football", "Soccer", "FSI" all map to "Football").
}
\details{
Classify Sports from Group Names
}
\examples{
\donttest{
if (FALSE) {
  metadata <- standardize_vald_metadata(profiles, groups)
  metadata <- classify_sports(metadata)
  table(metadata$sports_clean)
}
}
}
