% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vachette_data.R
\name{apply_transformations}
\alias{apply_transformations}
\alias{apply_transformations.vachette_data}
\title{Apply vachette transformations}
\usage{
apply_transformations(vachette_data, ...)

\method{apply_transformations}{vachette_data}(
  vachette_data,
  tol.end = 0.001,
  tol.noise = 1e-08,
  step.x.factor = 1.5,
  ngrid.fit = 100,
  window = 17,
  log_file = NULL,
  ...
)
}
\arguments{
\item{vachette_data}{object of class \code{vachette_data}}

\item{...}{Additional arguments}

\item{tol.end}{numeric; Relative tolerance to determine last x open end reference}

\item{tol.noise}{numeric; Relative tolerance for landmark determination typical curves}

\item{step.x.factor}{numeric; x-axis extension factor to search for last x, i.e., to determine where close enough to asymptote}

\item{ngrid.fit}{numeric; number of grid points in last query segment for matching last reference segment}

\item{window}{integer; size (gridpoints) of Savitzky Golay smoothing window for landmark position determination}

\item{log_file}{character; File path to direct console output e.g., \code{"log.txt"}}
}
\value{
\code{vachette_data} object containing a list of vachette-transformed \code{data.frame}s
}
\description{
Apply vachette transformations
}
\examples{
obs <- read.csv(system.file(package = "vachette", "examples", "iv-obs.csv"))
typ <- read.csv(system.file(package = "vachette", "examples", "iv-typ-minmax.csv"))

vd <- vachette_data(
  obs.data = obs,
  typ.data = typ,
  covariates = c(WT = 70),
  mappings = c(OBS = "DV", x = "time"),
  model.name  = "IV"
 )

 vd <- apply_transformations(vd)

}
