% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_conservationLevel.R
\name{plot_conservationLevel}
\alias{plot_conservationLevel}
\title{Conservation Levels Distribution Plot}
\usage{
plot_conservationLevel(
  df,
  proteinOrder = "",
  conservationLabel = 1,
  host = 1,
  base_size = 11,
  label_size = 2.6,
  alpha = 0.6
)
}
\arguments{
\item{df}{DiMA JSON converted csv file data}

\item{proteinOrder}{order of proteins displayed in plot}

\item{conservationLabel}{0 (partial; show present conservation labels only) or 1 (full; show ALL conservation labels) in plot}

\item{host}{number of host (1/2)}

\item{base_size}{base font size in plot}

\item{label_size}{conservation labels font size}

\item{alpha}{any number from 0 (transparent) to 1 (opaque)}
}
\value{
A plot
}
\description{
This function plots conservation levels distribution of k-mer positions, which consists of
completely conserved (black) (index incidence = 100\%), highly conserved (blue)
(90\% <= index incidence < 100\%), mixed variable (green) (20\% < index incidence <= 90\%),
highly diverse (purple) (10\% < index incidence <= 20\%) and
extremely diverse (pink) (index incidence <= 10\%).
}
\examples{
plot_conservationLevel(proteins_1host, conservationLabel = 1,alpha=0.8, base_size = 15)
plot_conservationLevel(protein_2hosts, conservationLabel = 0, host=2)
}
