% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{paste_freq}
\alias{paste_freq}
\title{Paste Frequency}
\usage{
paste_freq(count = NA, total = NA, percent.sign = TRUE, digits = 1)
}
\arguments{
\item{count}{Required. Tibble, Column (logical), or Numeric. The numerator.
Tibbles and columns are automatically tallied (nrow or sum(na.rm = TRUE)).}

\item{total}{Required. Tibble, Column, or Numeric. The denominator. Tibbles
and columns are automatically tallied (nrow or sum(na.rm = TRUE)).}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed
for frequencies. Defaults to TRUE.}

\item{digits}{Optional. Integer. Number of digits to round to. Defaults to 1.}
}
\description{
Returns a human-readable frequency from count(able) data. Supports
vectorized data (i.e. dplyr::mutate()).
}
\examples{
library(tibble)

# Numeric
paste_freq(20, 100)

# Tibble
data_tibble <- tibble(column = c(1:100))
paste_freq(data_tibble[1:20,], data_tibble)
}
