% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustfd.R
\name{ustfd_response_payload}
\alias{ustfd_response_payload}
\title{Extract Payload as Table From Parsed API Response}
\usage{
ustfd_response_payload(response)
}
\arguments{
\item{response}{a parsed response returned by \code{\link[=ustfd_json_response]{ustfd_json_response()}}}
}
\value{
a tibble
}
\description{
\code{ustfd_response_payload()} will return the results of the query in tabular
format in the form of a tibble with one column for each field returned and
one row for every record returned in the same order they were returned.
}
\examples{
\dontrun{
library(ustfd)
query <- ustfd_query('/v1/accounting/dts/dts_table_4', sort =c('-record_date'))
response <- ustfd_request(query)
payload_table <- ustfd_response_payload(response)
payload_meta <- ustfd_response_meta_object(response)
}

}
\seealso{
Other ustfd_low_level: 
\code{\link{ustfd_json_response}()},
\code{\link{ustfd_request}()},
\code{\link{ustfd_response_meta_object}()},
\code{\link{ustfd_url}()}
}
\concept{ustfd_low_level}
