\docType{methods}
\name{peak.scalability,USL-method}
\alias{peak.scalability}
\alias{peak.scalability,USL-method}
\title{Peak scalability value of a USL model}
\usage{
\S4method{peak.scalability}{USL}(object, sigma, kappa)
}
\arguments{
  \item{object}{A USL object.}

  \item{sigma}{Optional parameter to be used for evaluation
  instead of the parameter computed for the model.}

  \item{kappa}{Optional parameter to be used for evaluation
  instead of the parameter computed for the model.}
}
\value{
A numeric value for the point where peak scalability will
be reached.
}
\description{
Calculate the point of peak scalability for a specific
model.
}
\details{
The peak scalability is the point where the throughput of
the system starts to go retrograde, i.e., starts to
decrease with increasing load.

The parameters \code{sigma} or \code{kappa} are useful to
do a what-if analysis. Setting these parameters override
the model parameters and show how the system would behave
with a different contention or coherency delay parameter.

See formula (4.33) in \emph{Guerilla Capacity Planning}.
}
\examples{
require(usl)

data(raytracer)

peak.scalability(usl(throughput ~ processors, raytracer))
## Peak scalability will be reached just below 450 processors
}
\references{
Neil J. Gunther. Guerrilla Capacity Planning: A Tactical
Approach to Planning for Highly Scalable Applications and
Services.  Springer, Heidelberg, Germany, 1st edition,
2007.
}
\seealso{
\code{\link{usl}}, \code{\link{scalability,USL-method}}
}

