#' Use a basic `NAMESPACE`
#'
#' If `roxygen` is `TRUE` generates an empty `NAMESPACE` that exports nothing;
#' you'll need to explicitly export functions with `@export`. If `roxygen`
#' is `FALSE`, generates a default `NAMESPACE` that exports all functions
#' except those that start with `.`.
#'
#' @param roxygen Do you plan to manage `NAMESPACE` with roxygen2?
#' @seealso The [namespace
#'   chapter](https://r-pkgs.org/dependencies-mindset-background.html#sec-dependencies-namespace)
#'   of [R Packages](https://r-pkgs.org).
#' @export
use_namespace <- function(roxygen = TRUE) {
  check_is_package("use_namespace()")

  path <- proj_path("NAMESPACE")
  if (roxygen) {
    write_over(path, c("# Generated by roxygen2: do not edit by hand", ""))
  } else {
    write_over(path, 'exportPattern("^[^\\\\.]")')
  }
}
