% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_from_github}
\alias{create_from_github}
\title{Create a project from a GitHub repo}
\usage{
create_from_github(
  repo_spec,
  destdir = NULL,
  fork = NA,
  rstudio = NULL,
  open = rlang::is_interactive(),
  protocol = git_protocol(),
  host = NULL,
  auth_token = deprecated(),
  credentials = deprecated()
)
}
\arguments{
\item{repo_spec}{A string identifying the GitHub repo in one of these forms:
\itemize{
\item Plain \code{OWNER/REPO} spec
\item Browser URL, such as \code{"https://github.com/OWNER/REPO"}
\item HTTPS Git URL, such as \code{"https://github.com/OWNER/REPO.git"}
\item SSH Git URL, such as \code{"git@github.com:OWNER/REPO.git"}
}

In the case of a browser, HTTPS, or SSH URL, the \code{host} is extracted from
the URL. The \code{REPO} part will be the name of the new local folder, which is
also a project and Git repo.}

\item{destdir}{The new folder is stored here. If \code{NULL}, defaults to user's
Desktop or some other conspicuous place. You can also set a default
location using the option \code{usethis.destdir}, e.g.
\code{options(usethis.destdir = "a/good/dir")}, perhaps saved to your
\code{.Rprofile} with \code{\link[=edit_r_profile]{edit_r_profile()}}}

\item{fork}{If \code{FALSE}, we clone \code{repo_spec}. If \code{TRUE}, we fork
\code{repo_spec}, clone that fork, and do additional set up favorable for
future pull requests:
\itemize{
\item The source repo, \code{repo_spec}, is configured as the \code{upstream} remote,
using the indicated \code{protocol}.
\item The local \code{DEFAULT} branch is set to track \code{upstream/DEFAULT}, where
\code{DEFAULT} is typically \code{master} or \code{main}. It is also immediately pulled,
to cover the case of a pre-existing, out-of-date fork.
}

If \code{fork = NA} (the default), we check your permissions on \code{repo_spec}. If
you can push, we set \code{fork = FALSE}, If you cannot, we set \code{fork = TRUE}.}

\item{rstudio}{Initiate an \href{https://support.rstudio.com/hc/en-us/articles/200526207-Using-Projects}{RStudio Project}?
Defaults to \code{TRUE} if in an RStudio session and project has no
pre-existing \code{.Rproj} file. Defaults to \code{FALSE} otherwise (but note that
the cloned repo may already be an RStudio Project, i.e. may already have a
\code{.Rproj} file).}

\item{open}{If \code{TRUE}, \link[=proj_activate]{activates} the new project:
\itemize{
\item If RStudio desktop, the package is opened in a new session.
\item If on RStudio server, the current RStudio project is activated.
\item Otherwise, the working directory and active project is changed.
}}

\item{protocol}{One of "https" or "ssh"}

\item{host}{GitHub host to target, passed to the \code{.api_url} argument of
\code{\link[gh:gh]{gh::gh()}}. If unspecified, gh defaults to "https://api.github.com",
although gh's default can be customised by setting the GITHUB_API_URL
environment variable.

For a hypothetical GitHub Enterprise instance, either
"https://github.acme.com/api/v3" or "https://github.acme.com" is
acceptable.}

\item{auth_token}{\ifelse{html}{\figure{lifecycle-deprecated.svg}{options: alt='Deprecated lifecycle'}}{\strong{Deprecated}}: No longer
consulted now that usethis uses the gert package for Git operations,
instead of git2r; gert relies on the credentials package for auth. The API
requests are now authorized with the token associated with the \code{host}, as
retrieved by \code{\link[gh:gh_token]{gh::gh_token()}}.}

\item{credentials}{\ifelse{html}{\figure{lifecycle-deprecated.svg}{options: alt='Deprecated lifecycle'}}{\strong{Deprecated}}: No longer
consulted now that usethis uses the gert package for Git operations,
instead of git2r; gert relies on the credentials package for auth. The API
requests are now authorized with the token associated with the \code{host}, as
retrieved by \code{\link[gh:gh_token]{gh::gh_token()}}.}
}
\description{
Creates a new local project and Git repository from a repo on GitHub, by
either cloning or
\href{https://help.github.com/articles/fork-a-repo/}{fork-and-cloning}. In the
fork-and-clone case, \code{create_from_github()} also does additional remote and
branch setup, leaving you in the perfect position to make a pull request with
\code{\link[=pr_init]{pr_init()}}, one of several \link[=pull-requests]{functions that work pull requests}.

\code{create_from_github()} works best when your GitHub credentials are
discoverable. See below for more about authentication.
}
\section{Git/GitHub Authentication}{

Many usethis functions, including those documented here, potentially interact
with GitHub in two different ways:
\itemize{
\item Via the GitHub REST API. Examples: create a repo, a fork, or a pull
request.
\item As a conventional Git remote. Examples: clone, fetch, or push.
}

Therefore two types of auth can happen and your credentials must be
discoverable. Which credentials do we mean?
\itemize{
\item A GitHub personal access token (PAT) must be discoverable by the gh
package, which is used for GitHub operations via the REST API. See
\code{\link[=gh_token_help]{gh_token_help()}} for more about getting and configuring a PAT.
\item If you use the HTTPS protocol for Git remotes, your PAT is also used for
Git operations, such as \verb{git push}. Usethis uses the gert package for this,
so the PAT must be discoverable by gert. Generally gert and gh will
discover and use the same PAT. This ability to "kill two birds with one
stone" is why HTTPS + PAT is our recommended auth strategy for those new
to Git and GitHub and PRs.
\item If you use SSH remotes, your SSH keys must also be discoverable, in
addition to your PAT. The public key must be added to your GitHub account.
}

Git/GitHub credential management is covered in a dedicated article:
\href{https://usethis.r-lib.org/articles/articles/git-credentials.html}{Managing Git(Hub) Credentials}
}

\examples{
\dontrun{
create_from_github("r-lib/usethis")

# repo_spec can be a URL
create_from_github("https://github.com/r-lib/usethis")

# a URL repo_spec also specifies the host (e.g. GitHub Enterprise instance)
create_from_github("https://github.acme.com/OWNER/REPO")
}
}
\seealso{
\itemize{
\item \code{\link[=use_github]{use_github()}} to go the opposite direction, i.e. create a GitHub repo
from your local repo
\item \code{\link[=git_protocol]{git_protocol()}} for background on \code{protocol} (HTTPS vs SSH)
\item \code{\link[=use_course]{use_course()}} to download a snapshot of all files in a GitHub repo,
without the need for any local or remote Git operations
}
}
