% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git.R
\name{use_git_remote}
\alias{use_git_remote}
\alias{git_remotes}
\title{Configure and report Git remotes}
\usage{
use_git_remote(name = "origin", url, overwrite = FALSE)

git_remotes()
}
\arguments{
\item{name}{A string giving the short name of a remote.}

\item{url}{A string giving the url of a remote.}

\item{overwrite}{Logical. Controls whether an existing remote can be
modified.}
}
\value{
Named list of Git remotes.
}
\description{
Two helpers are available:
\itemize{
\item \code{use_git_remote()} sets the remote associated with \code{name} to \code{url}.
\item \code{git_remotes()} reports the configured remotes, similar to
\code{git remote -v}.
}
}
\examples{
\dontrun{
# see current remotes
git_remotes()

# add new remote named 'foo', a la `git remote add <name> <url>`
use_git_remote(name = "foo", url = "https://github.com/<OWNER>/<REPO>.git")

# remove existing 'foo' remote, a la `git remote remove <name>`
use_git_remote(name = "foo", url = NULL, overwrite = TRUE)

# change URL of remote 'foo', a la `git remote set-url <name> <newurl>`
use_git_remote(
  name = "foo",
  url = "https://github.com/<OWNER>/<REPO>.git",
  overwrite = TRUE
)

# Scenario: Fix remotes when you cloned someone's repo, but you should
# have fork-and-cloned (in order to make a pull request).

# Store origin = main repo's URL, e.g., "git@github.com:<OWNER>/<REPO>.git"
upstream_url <- git_remotes()[["origin"]]

# IN THE BROWSER: fork the main GitHub repo and get your fork's remote URL
my_url <- "git@github.com:<ME>/<REPO>.git"

# Rotate the remotes
use_git_remote(name = "origin", url = my_url)
use_git_remote(name = "upstream", url = upstream_url)
git_remotes()

# Scenario: Add upstream remote to a repo that you fork-and-cloned, so you
# can pull upstream changes.
# Note: If you fork-and-clone via `usethis::create_from_github()`, this is
# done automatically!

# Get URL of main GitHub repo, probably in the browser
upstream_url <- "git@github.com:<OWNER>/<REPO>.git"
use_git_remote(name = "upstream", url = upstream_url)
}
}
