% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{unnest}
\alias{unnest}
\title{Unnest lists}
\usage{
unnest(
  x,
  spec = NULL,
  dedupe = FALSE,
  stack_atomic = NULL,
  process_atomic = NULL,
  process_unnamed_lists = NULL,
  cross_join = TRUE
)
}
\arguments{
\item{x}{a nested list to unnest}

\item{spec}{spec to use for unnesting. See \code{\link[=spec]{spec()}}.}

\item{dedupe}{whether to dedupe repeated elements. If TRUE, if a node is
visited for a second time and is not explicitly declared in the \code{spec} the
node is skipped. This is particularly useful with \code{group}ed specs.}

\item{stack_atomic}{Whether atomic leaf vectors should be stacked or not. If
NULL, the default, data.frame vectors are stacked, all others are spread.}

\item{process_atomic}{Process spec for atomic leaf vectors. Either NULL for
no processing (the default), "as_is" to return the entire element in a list
column, "paste" to paste elements together into a character column.}

\item{process_unnamed_lists}{How to process unnamed lists. Can be one of
"as_is" - return a list column, "exclude" - drop these elements unless they
are explicitly included in the spec, "paste" - return a character column,
"stack" - automatically stack. If NULL (the default), do nothing - process
them normally according to the specs.}

\item{cross_join}{Specifies how the results from sibling nodes are joined
(\code{cbind}ed) together. The shorter data.frames (fewer rows) can be either
recycled to the max number of rows across all joined components with
\code{cross_join = FALSE}. Or, the results are cross joined (produce all
combinations of rows across all components) with \code{cross_join = TRUE}. \code{cross_join = TRUE} is the default because of no data loss and it is
more conducive for earlier error detection with incorrect specs}
}
\value{
A \code{data.frame}, \code{data.table} or a \code{tibble} as specified by the option
\code{unnest.return.type}. Defaults to \code{data.frame}.
}
\description{
Unnest nested lists into a flat data.frames.
}
\examples{

x <- list(a = list(b = list(x = 1, y = 1:2, z = 10),
                   c = list(x = 2, y = 100:102)))
xxx <- list(x, x, x)

## spreading
unnest(x, s("a"))
unnest(x, s("a"), stack_atomic = TRUE)
unnest(x, s("a/b"), stack_atomic = TRUE)
unnest(x, s("a/c"), stack_atomic = TRUE)
unnest(x, s("a"), stack_atomic = TRUE, cross_join = TRUE)
unnest(x, s("a//x"))
unnest(x, s("a//x,z"))
unnest(x, s("a/2/x,y"))

## stacking
unnest(x, s("a/", stack = TRUE))
unnest(x, s("a/", stack = TRUE, as = "A"))
unnest(x, s("a/", stack = TRUE, as = "A"), stack_atomic = TRUE)
unnest(x, s("a/", stack = "id"), stack_atomic = TRUE)
unnest(x, s("a/", stack = "id", as = ""), stack_atomic = TRUE)

unnest(xxx, s(stack = "id"))
unnest(xxx, s(stack = "id"), stack_atomic = TRUE)
unnest(xxx, s(stack = "id", s("a/b/y/", stack = TRUE)))

## exclusion
unnest(x, s("a/b/", exclude = "x"))

## dedupe
unnest(x, s("a", s("b/y"), s("b")), stack_atomic = TRUE)
unnest(x, s("a", s("b/y"), s("b")), dedupe = TRUE, stack_atomic = TRUE)

## grouping
unnest(xxx, stack_atomic = TRUE,
       s(stack = TRUE,
         groups = list(first = s("a/b/x,y"),
                       second = s("a/b"))))

unnest(xxx, stack_atomic = TRUE, dedupe = TRUE,
       s(stack = TRUE,
         groups = list(first = s("a/b/x,y"),
                       second = s("a/b"))))

## processing as_is
str(unnest(xxx, s(stack = "id",
                  s("a/b/y", process = "as_is"),
                  s("a/c", process = "as_is"))))
str(unnest(xxx, s(stack = "id", s("a/b/", process = "as_is"))))
str(unnest(xxx, s(stack = "id", s("a/b", process = "as_is"))))

## processing paste
str(unnest(x, s("a/b/y", process = "paste")))
str(unnest(xxx, s(stack = TRUE, s("a/b/", process = "paste"))))
str(unnest(xxx, s(stack = TRUE, s("a/b", process = "paste"))))

## default
unnest(x, s("a/b/c/", s("b", default = 100)))
unnest(x, s("a/b/c/", stack = "ix", s("b", default = 100)))

}
