\name{ut_cmp_error}
\alias{ut_cmp_error}

\title{Test for and compare errors generated by code}

\description{A helper to catch expected errors and ensure they match what is expected}

\usage{
  ut_cmp_error(code, expected_regexp, ignore.case = FALSE, perl = FALSE, fixed = FALSE)
}

\arguments{
  \item{code}{Code expression to test, should generate an error}
  \item{expected_regexp}{Regular expression the error should match}
  \item{ignore.case}{Passed to \code{\link{grepl}}}
  \item{perl}{Passed to \code{\link{grepl}}}
  \item{fixed}{Passed to \code{\link{grepl}}}
}

\value{
  Returns \code{TRUE} if \code{exp} generates an error and matches \code{expected_regexp}.
  Returns a string with expected and actual error if \code{exp} generates an error but does not match.
  Returns \code{"No error returned"} if \code{exp} does not generate an error.
}

\examples{
  ok(ut_cmp_error({
    stop("Hammer time")
  }, "hammer", ignore.case = TRUE), "Returned a hammer-based error")

  \dontshow{
    # Clear unittest result log, so our unittest failues don't fail example-building
    rm('outcomes', pos = unittest:::pkg_vars)
    rm('errors', pos = unittest:::pkg_vars)
  }
}
