% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_def_2.R
\docType{data}
\name{pal_unikn_pair}
\alias{pal_unikn_pair}
\title{uni.kn color palette of pairwise colors (16 colors)}
\format{
An object of class \code{data.frame} with 1 rows and 16 columns.
}
\usage{
pal_unikn_pair
}
\description{
\code{pal_unikn_pair} provides an additional uni.kn color palette  
that collects 16 paired colors of 8 color palettes  
as a data frame containing 16 colors (in 8 pairs).
}
\details{
See \url{https://www.uni-konstanz.de/en/university/news-and-media/create-online-and-print-media/corporate-design/} for details.
}
\examples{
pal_unikn_pair
dim(pal_unikn_pair)  # 1 16
pal_unikn_pair[1]    # color "karpfenblau4" by position
pal_unikn_pair[[1]]  # color value by position: #3E5496"
pal_unikn_pair["karpfenblau4"]  # color value by name

# Viewing/using color palette:
seecol(pal_unikn_pair)
demopal(pal_unikn_pair, type = "polygon", main = "A pair-wise color palette")

}
\seealso{
\code{\link{pal_unikn_light}} for a lighter uni.kn color palette; 
\code{\link{pal_unikn_dark}} for a darker uni.kn color palette; 
\code{\link{pal_unikn}} for the default uni.kn color palette; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes.

Other color palettes: 
\code{\link{pal_bordeaux}},
\code{\link{pal_grau}},
\code{\link{pal_karpfenblau}},
\code{\link{pal_peach}},
\code{\link{pal_petrol}},
\code{\link{pal_pinky}},
\code{\link{pal_seeblau}},
\code{\link{pal_seegruen}},
\code{\link{pal_signal}},
\code{\link{pal_unikn_dark}},
\code{\link{pal_unikn_light}},
\code{\link{pal_unikn_ppt}},
\code{\link{pal_unikn_pref}},
\code{\link{pal_unikn_web}},
\code{\link{pal_unikn}}
}
\concept{color palettes}
\keyword{datasets}
