% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Macquarie.R
\docType{data}
\name{mq_1}
\alias{mq_1}
\title{Primary colors of Macquarie University, Australia}
\format{
An object of class \code{character} of length 7.
}
\source{
MQ's staff portal page 
\href{https://staff.mq.edu.au/support/marketing-and-communications/brand-guidelines/colours-and-light-graphic}{Colours and light graphic}
}
\usage{
mq_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{mq_1} provides the primary colors 
of \href{https://www.mq.edu.au}{Macquarie University}, located in Sydney, Australia.
}
\details{
\code{mq_1} uses the HEX color definitions.


A refreshed \code{Macquarie red} (defined as \code{"#A6192E"}) 
builds on the equity in the Macquarie University colour palette.

\code{Deep red} and \code{Bright red} provide depth.
\code{Magenta} and \code{Purple} inject energy.
\code{Charcoal} and \code{Sand} provide contrast.
}
\examples{
mq_1
unikn::seecol(mq_1, main = "Primary colours of Macquarie University") # view color palette

}
\seealso{
\code{\link{mq_2}} for faculty colours of Macquarie University; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Australian university color palettes: 
\code{\link{ANU_1}},
\code{\link{ANU_2}},
\code{\link{mq_2}},
\code{\link{wollongong_1}},
\code{\link{wollongong_2}}
}
\author{
\strong{unicol}, 2023-09-05.
}
\concept{Australian university color palettes}
\keyword{datasets}
