% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HU_Berlin.R
\docType{data}
\name{hu_3_accent}
\alias{hu_3_accent}
\title{Possible accent colors of the Humboldt University (HU) Berlin, Germany}
\format{
An object of class \code{character} of length 9.
}
\source{
Color definitions are based on HU's 
\href{https://www.hu-berlin.de/de/service/design/basiselemente/farbe}{Corporate Design guide} 
(see p. 21 of the PDF manual).
}
\usage{
hu_3_accent
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{hu_3_accent} provides nine possible accent colors 
of the \href{https://www.hu-berlin.de/en}{Humboldt University Berlin}, Germany, 
updated in 2023.
}
\details{
Accent colors are meant to be bright and friendly and can 
-- provided that they are used sparingly and specifically -- 
complement the primary and secondary colors. 

Note that the HU corporate design manual prohibits the use of 
earthy, swampy, and pastel colors, and the colors of other Berlin institutions. 

\code{hu_3_accent} uses HEX color definitions.
}
\examples{
hu_3_accent
unikn::seecol(hu_3_accent, main = "Accent colors of HU Berlin")  # view color palette
unikn::demopal(hu_3_accent, type = 1, main = "Accent colors of Humboldt University Berlin")

}
\seealso{
\code{\link{hu_1}} for primary colors of the HU Berlin; 
\code{\link{hu_1_digital}} for digital colors of the HU Berlin;  
\code{\link{hu_2}} for secondary colors of the HU Berlin; 
\code{\link{hu_1_2022}} for primary colors of the HU Berlin (2022); 
\code{\link{hu_2_2022}} for secondary colors of the HU Berlin (2022);  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_1}},
\code{\link{hu_2_2022}},
\code{\link{hu_2}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2023-08-31.
}
\concept{German university color palettes}
\keyword{datasets}
