% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Florida.R
\docType{data}
\name{uflorida_2}
\alias{uflorida_2}
\title{Secondary colors of the University of Florida, USA}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on the
\href{https://brandcenter.ufl.edu/colors/}{UFL brand center}.
}
\usage{
uflorida_2
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uflorida_2} provides the 5 secondary colors
of the \href{https://www.ufl.edu/}{University of Florida}, USA.
}
\details{
The 5 secondary colors are
\code{"ufl_bottlebrush"} (defined as HEX #D32737),
\code{"ufl_alachua"} (defined as HEX #F2A900),
\code{"ufl_gator"} (defined as HEX #2284C),
\code{"ufl_dark_blue"} (defined as HEX #002657) and
\code{"ufl_perennial"} (defined as HEX #6A2A60).

\code{uflorida_2} uses the HEX color definitions.
}
\examples{
uflorida_2
unikn::seecol(uflorida_2, main = "University of Florida 2") # view color palette

}
\seealso{
\code{\link{uflorida_1}} for primary colors of the University of Florida;
\code{\link{uflorida_3}} for neutral colors of the University of Florida; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other university color palettes.: 
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{limerick_2}},
\code{\link{notredame_2}},
\code{\link{trinity_2}},
\code{\link{uci_2}},
\code{\link{vanderbilt_2}}
}
\author{
\strong{unicol}, 2320-07-07.
}
\concept{university color palettes.}
\keyword{datasets}
