% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pubmed.R
\docType{methods}
\name{searchPublications}
\alias{searchPublications}
\alias{searchPublications,matrix-method}
\title{Carry out Pubmed search for a mtrix}
\usage{
searchPublications(query)

\S4method{searchPublications}{matrix}(query)
}
\arguments{
\item{query}{A matrix, as input to getUniqueGenes,  string to be submitted to Pubmed}
}
\value{
A 2 column matrix containg the query string and a list of \code{pubmed} objects each detailing a publication relating to the respective query.
}
\description{
\code{searchPublications} carries out a series of Pubmed searches for each row of information in the given matrix.
The function uses the same matrix used for input to the \code{getUniqueGeneList} function, however
given the nature of the search it is best to ensure the groups have meaningful names and not arbitrary numbers.
}
\section{Methods (by class)}{
\itemize{
\item \code{matrix}: as above.
}}
\examples{
\dontrun{
query   f <- matrix(c("Axitinib","BRAF","Imatinib","BRAF"),ncol=2,byrow=TRUE)
ReturnedPublications <- searchPublications(query)
}
}

