% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{fin_valuation}
\alias{fin_valuation}
\title{Work the valuation of a company}
\usage{
fin_valuation(
  revenue = 6e+06 * 30000,
  opmargin = 0.08,
  expenses = 0.2,
  PE = 30,
  symbol = "$",
  use = c("B", "M")
)
}
\arguments{
\item{revenue}{Revenue of the company}

\item{opmargin}{Margin on operating revenue}

\item{expenses}{Additional fixed costs}

\item{PE}{of the company}

\item{symbol}{Currency}

\item{use}{reporting values in "B" (billion) or "M" (millions)}
}
\value{
\itemize{
\item value
}
}
\description{
\code{fin_valuation} uses the revenue, operating margin, expenses and PE to compute a market capitalization
}
\details{
Revenue is multiplied by opmargin to get a gross profit. From this the proportion specified in \code{expenses} is subtracted
and the resulting earnings turned into a price via the \code{PE}
}
\examples{
fin_valuation(rev=7e9, opmargin=.1, PE=33)
# Market cap =  $18,480,000,000
# (Based on PE= 33, operating Income of $0.70 B, and net income =$0.56B

}
\seealso{
\itemize{
\item \code{\link[=fin_interest]{fin_interest()}}
}

Other Miscellaneous Functions: 
\code{\link{deg2rad}()},
\code{\link{fin_interest}()},
\code{\link{fin_percent}()},
\code{\link{loadings.MxModel}()},
\code{\link{rad2deg}()},
\code{\link{umxBrownie}()}
}
\concept{Miscellaneous Functions}
