% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxDoC.R
\name{umxSummaryDoC}
\alias{umxSummaryDoC}
\alias{umxSummary.MxModelDoC}
\title{Shows a compact, publication-style, summary of a umx Direction of Causation model}
\usage{
umxSummaryDoC(
  model,
  digits = 2,
  comparison = NULL,
  std = TRUE,
  showRg = FALSE,
  CIs = TRUE,
  report = c("markdown", "html"),
  file = getOption("umx_auto_plot"),
  returnStd = FALSE,
  zero.print = ".",
  ...
)
}
\arguments{
\item{model}{a fitted \code{\link[=umxDoC]{umxDoC()}} model to summarize.}

\item{digits}{round to how many digits (default = 2).}

\item{comparison}{Run mxCompare on a comparison model (default NULL)}

\item{std}{Whether to standardize the output (default = TRUE).}

\item{showRg}{= whether to show the genetic correlations (FALSE).}

\item{CIs}{Whether to show Confidence intervals if they exist (TRUE).}

\item{report}{Print tables to the console (as 'markdown'), or open in browser ('html')}

\item{file}{The name of the dot file to write: "name" = use the name of the model.
Defaults to NA = do not create plot output.}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE).}

\item{zero.print}{How to show zeros (".")}

\item{...}{Other parameters to control model summary.}
}
\value{
\itemize{
\item optional \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}}
}
}
\description{
Summarize a fitted model returned by \code{\link[=umxDoC]{umxDoC()}}. Can control digits, report comparison model fits,
optionally show the Rg (genetic and environmental correlations), and show confidence intervals. the report parameter allows
drawing the tables to a web browser where they may readily be copied into non-markdown programs like Word.
}
\details{
See documentation for other umx models here: \code{\link[=umxSummary]{umxSummary()}}.
}
\examples{
\dontrun{
# ================
# = 1. Load Data =
# ================
data(docData)
mzData = subset(docData, zygosity \%in\% c("MZFF", "MZMM"))
dzData = subset(docData, zygosity \%in\% c("DZFF", "DZMM"))

# =======================================
# = 2. Define manifests for var 1 and 2 =
# =======================================
var1 = paste0("varA", 1:3)
var2 = paste0("varB", 1:3)

# =======================================================
# = 2. Make the non-causal (Cholesky) and causal models =
# =======================================================
Chol= umxDoC(var1= var1, var2= var2, mzData= mzData, dzData= dzData, causal= FALSE)
DoC = umxDoC(var1= var1, var2= var2, mzData= mzData, dzData= dzData, causal= TRUE)

# ================================================
# = Make the directional models by modifying DoC =
# ================================================
A2B = umxModify(DoC, "a2b", free = TRUE, name = "A2B")
A2B = umxModify(DoC, "a2b", free = TRUE, name = "A2B", comp=TRUE)
B2A = umxModify(DoC, "b2a", free = TRUE, name = "B2A", comp=TRUE)
umxCompare(B2A, A2B)

}
}
\seealso{
\itemize{
\item \code{\link[=umxDoC]{umxDoC()}}, \code{\link[=plot.MxModelDoC]{plot.MxModelDoC()}}, \code{\link[=umxModify]{umxModify()}}, \code{\link[=umxCP]{umxCP()}}, \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}}
}

Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umx}},
\code{\link{umxACE}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxCP}()},
\code{\link{umxDiffMZ}()},
\code{\link{umxDiscTwin}()},
\code{\link{umxDoC}()},
\code{\link{umxDoCp}()},
\code{\link{umxGxE}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxIP}()},
\code{\link{umxMRDoC}()},
\code{\link{umxReduce}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()}
}
\concept{Twin Modeling Functions}
