% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_explode_twin_names}
\alias{umx_explode_twin_names}
\title{Break twin variable names (BMI_T1, BMI_T2) into base variable names (BMI, "_T", 1:2)}
\usage{
umx_explode_twin_names(df, sep = "_T")
}
\arguments{
\item{df}{vector of names or data.frame containing the data}

\item{sep}{text constant separating name from numeric 1:2 twin index.}
}
\value{
- list(baseNames, sep, twinIndexes)
}
\description{
Break names like Dep_T1 into a list of base names, a separator, and a 
vector of twin indexes. e.g.: c("Dep_T1", "Dep_T2", "Anx_T1", "Anx_T2") will become:

list(baseNames = c("Dep", "Anx"), sep = "_T", twinIndexes = c(1,2))
}
\examples{
require(umx)
data("twinData")
umx_explode_twin_names(twinData, sep = "")
umx_explode_twin_names(twinData, sep = NULL)

# Ignore this: just a single-character/single variable test case
x = round(10 * rnorm(1000, mean = -.2))
y = round(5 * rnorm(1000))
x[x < 0] = 0; y[y < 0] = 0
umx_explode_twin_names(data.frame(x_T1 = x, x_T2 = y), sep = "_T")
umx_explode_twin_names(data.frame(x_T11 = x, x_T22 = y), sep = "_T")
umx_explode_twin_names(c("x_T11", "x_T22"), sep = "_T")
}
\seealso{
[umx_paste_names()]

Other String Functions: 
\code{\link{umx_explode}()},
\code{\link{umx_grep}()},
\code{\link{umx_names}()},
\code{\link{umx_paste_names}()},
\code{\link{umx_rot}()},
\code{\link{umx_str_chars}()},
\code{\link{umx_str_from_object}()},
\code{\link{umx_trim}()},
\code{\link{umx}}
}
\concept{String Functions}
