% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_high_level_models.R
\name{umxMendelianRandomization}
\alias{umxMendelianRandomization}
\alias{umxTwoStage}
\title{Build a SEM implementing the equivalent of 2-stage least squares regression}
\usage{
umxMendelianRandomization(
  formula = Y ~ X,
  instruments = ~qtl,
  data,
  subset,
  weights,
  contrasts = NULL,
  name = "tsls",
  ...
)
}
\arguments{
\item{formula}{The structural equation to be estimated (default = Y ~ X). A constant is implied if not explicitly deleted.}

\item{instruments}{A one-sided formula specifying instrumental variables (default = qtl).}

\item{data}{Frame containing the variables in the model.}

\item{subset}{(optional) vector specifying a subset of observations to be used in fitting the model.}

\item{weights}{(optional) vector of weights to be used in the fitting process (not supported)
If specified should be a non-negative numeric vector with one entry for each observation,
to be used to compute weighted 2SLS estimates.}

\item{contrasts}{an optional list (not supported)}

\item{name}{for the model (default = "tsls")}

\item{...}{arguments to be passed along. (not supported)}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
\code{umxTwoStage} implementing the Structural Equation Model equivalent of a 2SLS regression.
For ease of learning, the function is modeled closely on the \code{\link[sem:tsls]{sem::tsls()}}.
}
\details{
The example is a \href{https://en.wikipedia.org/wiki/Mendelian_randomization}{Mendelian Randomization}
analysis showing the utility of SEM over two-stage regression.

The following figure shows how the ACE model appears as a path diagram:

\if{html}{\figure{TSLS.png}{options: width="50\%" alt="Figure: Mendelian Randomisation analysis.png"}}
\if{latex}{\figure{TSLS.pdf}{options: width=7cm}}
}
\examples{
library(umx)


# ====================================
# = Mendelian Randomization analysis =
# ====================================

\dontrun{
# Note: in practice: many more subjects are desirable - this just to let example run fast
df = umx_make_MR_data(1000) 
m1 = umxTwoStage(Y ~ X, instruments = ~ qtl, data = df)
parameters(m1)
plot(m1, means = FALSE, min="") # help DiagrammaR layout the plot.
m2 = umxModify(m1, "qtl_to_X", comparison=TRUE, tryHard="yes", name="QTL_affects_X") # yip
m3 = umxModify(m1, "X_to_Y"  , comparison=TRUE, tryHard="yes", name="X_affects_Y") # nope
plot(m3, means = FALSE)

# Errant analysis using ordinary least squares regression (WARNING this result is CONFOUNDED!!)
m1 = lm(Y ~ X    , data = df); coef(m1) # incorrect .35 effect of X on Y
m1 = lm(Y ~ X + U, data = df); coef(m1) # Controlling U reveals the true 0.1 beta weight
#
#
df = umx_make_MR_data(1e5) 
m1 = umxMendelianRandomization(Y ~ X, instruments = ~ qtl, data = df)
coef(m1)

# ======================
# = Now with sem::tsls =
# ======================
# library(sem) # may require you to install X11
m2 = sem::tsls(formula = Y ~ X, instruments = ~ qtl, data = df)
coef(m2)
m3 = tsls(formula = Y ~ X, instruments = ~ qtl, data = (df[1, "qtl"] = NA))
}
}
\references{
\itemize{
\item 
\itemize{
\item Fox, J. (1979) Simultaneous equation models and two-stage least-squares. In Schuessler, K. F. (ed.) \emph{Sociological Methodology}, Jossey-Bass.
}
}
\itemize{
\item Greene, W. H. (1993) \emph{Econometric Analysis}, Second Edition, Macmillan.
}
}
\seealso{
\itemize{
\item \code{\link[=umx_make_MR_data]{umx_make_MR_data()}}, \code{\link[sem:tsls]{sem::tsls()}}, \code{\link[=umxRAM]{umxRAM()}}
}

Other Super-easy helpers: 
\code{\link{umxEFA}()},
\code{\link{umx}}
}
\concept{Super-easy helpers}
