% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{geometric_mean}
\alias{geometric_mean}
\title{Geometric Mean}
\usage{
geometric_mean(x, na.rm = c(TRUE, FALSE))
}
\arguments{
\item{x}{A vector of values.}

\item{na.rm}{remove NAs by default.}
}
\value{
\itemize{
\item Geometric mean of x
}
}
\description{
The Geometric mean is the nth-root of the product of \code{n} input values.
Common uses include computing economic utility.  That is to say, the utility of
\code{c(1, 2, 10)} is \deqn{(1 * 2 * 10)/3} = 6.6 not 6.3 (the arithmetic mean).
}
\examples{
geometric_mean(c(50, 100))

# For a given sum, geometric mean is maximised with equality
geometric_mean(c(75,75))

v = c(1, 149); c(sum(v), geometric_mean(v), mean(v), median(v))
# 150.00000  12.20656  75.00000  75.00000

# Underlying logic
sqrt(50 * 100)

# Alternate form using logs
exp(mean(log(c(50 *100))))

# Reciprocal duality
1/geometric_mean(c(100, 50))
geometric_mean(c(1/100, 1/50))
}
\references{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Geometric_mean}
}
}
\seealso{
Other Miscellaneous Stats Functions: 
\code{\link{FishersMethod}()},
\code{\link{SE_from_p}()},
\code{\link{harmonic_mean}()},
\code{\link{oddsratio}()},
\code{\link{reliability}()},
\code{\link{umxCov2cor}()},
\code{\link{umxHetCor}()},
\code{\link{umxParan}()},
\code{\link{umxWeightedAIC}()},
\code{\link{umx_apply}()},
\code{\link{umx_cor}()},
\code{\link{umx_means}()},
\code{\link{umx_r_test}()},
\code{\link{umx_round}()},
\code{\link{umx_scale}()},
\code{\link{umx_var}()},
\code{\link{umx}}
}
\concept{Miscellaneous Stats Functions}
