% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxAPA}
\alias{umxAPA}
\alias{summaryAPA}
\title{Creates nicely formatted journal-style summaries of models, p-values, data-frames and much more.}
\usage{
umxAPA(
  obj = .Last.value,
  se = NULL,
  p = NULL,
  std = FALSE,
  digits = 2,
  use = "complete",
  min = 0.001,
  addComparison = NA,
  report = c("markdown", "html"),
  lower = TRUE,
  test = c("Chisq", "LRT", "Rao", "F", "Cp"),
  SEs = TRUE,
  means = TRUE
)
}
\arguments{
\item{obj}{A model (e.g. \code{\link[=lm]{lm()}}, \code{\link[=lme]{lme()}}, \code{\link[=glm]{glm()}}, \code{\link[=t.test]{t.test()}}), beta-value, or \link{data.frame}}

\item{se}{If obj is a beta, se treated as standard-error (returning a CI).
If obj is a model, used to select effect of interest (blank for all effects).
Finally, set se to the CI c(lower, upper), to back out the SE.}

\item{p}{If obj is a beta, use p-value to compute SE (returning a CI).}

\item{std}{Whether to report std betas (re-runs model on standardized data).}

\item{digits}{How many digits to round output.}

\item{use}{If obj is a data.frame, how to handle NAs (default = "complete")}

\item{min}{For a p-value, the smallest value to report numerically (default .001)}

\item{addComparison}{For a p-value, whether to add "</=" default (NA) adds "<" if necessary}

\item{report}{What to return (default = 'markdown'). Use 'html' to open a web table.}

\item{lower}{Whether to not show the lower triangle of correlations for a data.frame (Default TRUE)}

\item{test}{If obj is a glm, which test to use to generate p-values options = "Chisq", "LRT", "Rao", "F", "Cp"}

\item{SEs}{Whether or not to show correlations with their SE (Default TRUE)}

\item{means}{Whether or not to show means in a correlation table (Default TRUE)}
}
\value{
\itemize{
\item string
}
}
\description{
\code{umxAPA} creates APA-style reports from a range of statistical models, or to summarize data.
\enumerate{
\item Given an \code{\link[stats:lm]{stats::lm()}} model, \code{umxAPA} will return a formatted effect, including 95\% CI.
e.g.: \code{umxAPA(lm(mpg~wt, data=mtcars), "wt")} yields: \eqn{\beta} = -5.34 [-6.48, -4.20], p < 0.001. here "wt"
restricts the output to just the named effect.
\item \code{umxAPA} also supports \code{\link[=t.test]{t.test()}}, \code{\link[stats:glm]{stats::glm()}}, \code{\link[=cor.test]{cor.test()}}, and others as I need them.
\item Get a CI from \code{obj=beta} and se=se : \code{umxAPA(-0.30, .03)} returns \eqn{\beta} = -0.3 [-0.36, -0.24]
\item Back out an SE from \eqn{\beta} and CI: \code{umxAPA(-0.030, c(-0.073, 0.013))} returns \eqn{\beta} = -0.03, se = 0.02
\item Given only a number as obj, will be treated as a p-value, and returned in APA format.
\item Given a dataframe, \code{umxAPA} will return a table of correlations with means and SDs in the last row. e.g.:
\verb{umxAPA(mtcars[,c("cyl", "wt", "mpg", )]} yields:
\tabular{lccc}{
\tab cyl         \tab  wt          \tab mpg          \cr
cyl     \tab 1           \tab  0.78        \tab -0.85        \cr
wt      \tab 0.78        \tab  1           \tab -0.87        \cr
mpg     \tab -0.85       \tab  -0.87       \tab 1            \cr
mean_sd \tab 6.19 (1.79) \tab  3.22 (0.98) \tab 20.09 (6.03)
}
}
}
\examples{

# ========================================
# = Report lm (regression/anova) results =
# ========================================
umxAPA(lm(mpg ~ wt + disp, mtcars)) # Report all parameters
umxAPA(lm(mpg ~ wt + disp, mtcars), "wt") # Just effect of weight
umxAPA(lm(mpg ~ wt + disp, mtcars), std = TRUE) # Standardize model!

###############
# GLM example #
###############

df = mtcars
df$mpg_thresh = 0
df$mpg_thresh[df$mpg > 16] = 1
m1 = glm(mpg_thresh ~ wt + gear,data = df, family = binomial)
umxAPA(m1)

###############
# A t-Test    #
###############

umxAPA(t.test(x = 1:10, y = c(7:20)))
umxAPA(t.test(extra ~ group, data = sleep))

# ======================================================
# = Summarize DATA FRAME: Correlations + Means and SDs =
# ======================================================
umxAPA(mtcars[,1:3])
umxAPA(mtcars[,1:3], digits = 3)
umxAPA(mtcars[,1:3], lower = FALSE)
\dontrun{
umxAPA(mtcars[,1:3], report = "html")
}

# ==========================================
# = CONFIDENCE INTERVAL from effect and se =
# ==========================================
umxAPA(.4, .3) # parameter 2 interpreted as SE

# Input beta and CI, and back out the SE
umxAPA(-0.030, c(-0.073, 0.013), digits = 3)

# ====================
# = Format a p-value =
# ====================
umxAPA(.0182613)   #   0.02
umxAPA(.00018261) # < 0.001
umxAPA(.00018261, addComparison = FALSE) # 0.001

# ========================
# = Report a correlation =
# ========================
data(twinData)
tmp = subset(twinData, zygosity \%in\% c("MZFF", "MZMM"))
m1 = cor.test(~ wt1 + wt2, data = tmp)
umxAPA(m1)

}
\references{
\itemize{
\item \url{https://stats.idre.ucla.edu/r/dae/logit-regression/}, \url{https://github.com/tbates/umx}, \url{https://www.shengdongzhao.com/?p=1501}
}
}
\seealso{
\code{\link[=SE_from_p]{SE_from_p()}}

Other Reporting Functions: 
\code{\link{umxFactorScores}()},
\code{\link{umxGetLatents}()},
\code{\link{umxGetManifests}()},
\code{\link{umxGetModel}()},
\code{\link{umxGetParameters}()},
\code{\link{umxParameters}()},
\code{\link{umx_aggregate}()},
\code{\link{umx_time}()},
\code{\link{umx}}
}
\concept{Reporting Functions}
