% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{oddsratio}
\alias{oddsratio}
\title{Compute odds ratio (OR)}
\usage{
oddsratio(grp1 = c(n = 3, N = 10), grp2 = c(n = 1, N = 10), alpha = 0.05)
}
\arguments{
\item{grp1}{either odds for group 1, or cases and total N , e.g c(n=3, N=10)}

\item{grp2}{either odds for group 2, or cases and total N , e.g c(n=1, N=20)}

\item{alpha}{for CI (default = 0.05)}
}
\value{
\itemize{
\item List of odds in group 1 and group2, and the resulting OR and CI
}
}
\description{
Returns the odds in each group, and the odds ratio. Takes the cases (n) and total N as a list
of two numbers for each of two groups.
}
\details{
Returns a list of odds1, odds2, and OR + CI. Has a pretty-printing method so displays as:\if{html}{\out{<div class="sourceCode R">}}\preformatted{Group 1 odds = 0.43
Group 2 odds = 0.11
          OR = 3.86 CI95[0.160, 3.64]
}\if{html}{\out{</div>}}
}
\examples{
oddsratio(grp1 = c(1, 10), grp2 = c(3, 10))
oddsratio(grp1 = 0.111, grp2 = 0.429)
oddsratio(grp1 = c(3, 10), grp2 = c(1, 10))
oddsratio(grp1 = c(3, 10), grp2 = c(1, 10), alpha = .01)

}
\references{
\itemize{
\item \url{https://stats.idre.ucla.edu/r/dae/logit-regression/}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=umx_r_test]{umx_r_test()}}
}

Other Miscellaneous Stats Functions: 
\code{\link{FishersMethod}()},
\code{\link{SE_from_p}()},
\code{\link{geometric_mean}()},
\code{\link{harmonic_mean}()},
\code{\link{reliability}()},
\code{\link{umxCov2cor}()},
\code{\link{umxHetCor}()},
\code{\link{umxWeightedAIC}()},
\code{\link{umx_apply}()},
\code{\link{umx_cor}()},
\code{\link{umx_means}()},
\code{\link{umx_r_test}()},
\code{\link{umx_round}()},
\code{\link{umx_scale}()},
\code{\link{umx_var}()},
\code{\link{umx}}
}
\concept{Miscellaneous Stats Functions}
